//Model.java
//(C) Joseph Mack 2011, jmack (at) wm7d (dot) net, released under GPL v3 (or any later version)

//inspired by Joseph Bergin's MVC gui at http://csis.pace.edu/~bergin/mvc/mvcgui.html

//Model holds an int counter (that's all it is).
//Model is an Observable
//Model doesn't know about View or Controller

public class JournalModel extends java.util.Observable 
{	
	
	private int entryCounter;	//primitive, automatically initialised to 0

	public JournalModel()
	{

		System.out.println("Journal Model()");

		/**
 		RunMVC  instantiate model, view and controller, make all the connections,
		then since the Controller already has a reference to the model (which it uses to alter the status of the model),
		to initialise the model from the controller and have the model automatically update the view.
		*/

	} //Model()

	//uncomment this if View is using Model Pull to get the counter
	//not needed if getting counter from notifyObservers()
	//public int getValue(){return counter;}

	//notifyObservers()
	//model sends notification to view because of RunMVC: myModel.addObserver(myView)
	//myView then runs update()
	//
	//model Push - send counter as part of the message
	public void setValue(int value) 
	{

		this.entryCounter = value;
		System.out.println("Model init: " + entryCounter + "entries");
		setChanged();
		//model Push - send counter as part of the message
		notifyObservers(entryCounter);
		//if using Model Pull, then can use notifyObservers()
		//notifyObservers()

	} //setValue()
	
	public void incrementValue() 
	{

		++entryCounter;
		System.out.println("Model     : counter = " + entryCounter);
		setChanged();
		//model Push - send counter as part of the message
		notifyObservers(entryCounter);
		//if using Model Pull, then can use notifyObservers()
		//notifyObservers()

	} //incrementValue()
	
} //Model
